/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import noppes.npcs.CustomRegisters;
import noppes.npcs.api.ICustomElement;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.items.CustomItem;
import noppes.npcs.util.Util;

public class CustomBow
extends ItemBow
implements ICustomElement {
    protected NBTTagCompound nbtData;
    protected ItemStack repairItemStack;
    protected int enchantability = 0;
    private final Item.ToolMaterial material;
    public ItemStack itemArrow;
    protected boolean isFlame;
    private float critChance = 0.0f;
    private double attackDamage = 2.0;
    protected float speed = 30.0f;

    public CustomBow(NBTTagCompound nbtItem) {
        this.nbtData = nbtItem;
        this.setRegistryName("customnpcs", "custom_" + nbtItem.func_74779_i("RegistryName"));
        this.func_77655_b("custom_" + nbtItem.func_74779_i("RegistryName"));
        this.itemArrow = nbtItem.func_150297_b("Bullet", 10) ? new ItemStack(nbtItem.func_74775_l("Bullet")) : ItemStack.field_190927_a;
        this.isFlame = nbtItem.func_74767_n("SetFlame");
        if (nbtItem.func_150297_b("CritChance", 5)) {
            this.critChance = nbtItem.func_74760_g("CritChance");
        }
        this.material = CustomItem.getMaterialTool(nbtItem);
        if (nbtItem.func_150297_b("DrawstringSpeed", 5)) {
            this.speed = nbtItem.func_74760_g("DrawstringSpeed");
        }
        if (nbtItem.func_74762_e("MaxStackDamage") > 1) {
            this.func_77656_e(nbtItem.func_74762_e("MaxStackDamage"));
        }
        if (nbtItem.func_150297_b("EntityDamage", 6)) {
            this.attackDamage = nbtItem.func_74769_h("EntityDamage");
        }
        this.repairItemStack = nbtItem.func_150297_b("RepairItem", 10) ? new ItemStack(nbtItem.func_74775_l("RepairItem")) : this.material.getRepairItemStack();
        if (nbtItem.func_150297_b("IsFull3D", 1) && nbtItem.func_74767_n("IsFull3D")) {
            this.func_77664_n();
        }
        this.func_77637_a(CustomRegisters.tabItems);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                float f = 0.0f;
                if (entityIn != null) {
                    f = !(entityIn.func_184607_cu().func_77973_b() instanceof ItemBow) ? 0.0f : (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / ((CustomBow)stack.func_77973_b()).speed;
                }
                return f;
            }
        });
    }

    @Nonnull
    protected ItemStack func_185060_a(@Nonnull EntityPlayer player) {
        if (this.func_185058_h_(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.func_185058_h_(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.func_185058_h_(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public String getCustomName() {
        return this.nbtData.func_74779_i("RegistryName");
    }

    @Override
    public INbt getCustomNbt() {
        return Objects.requireNonNull(NpcAPI.Instance()).getINbt(this.nbtData);
    }

    public boolean func_82789_a(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        ItemStack mat = this.repairItemStack;
        if (this.repairItemStack.func_190926_b()) {
            mat = this.material.getRepairItemStack();
        }
        if (!mat.func_190926_b() && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public int func_77619_b() {
        if (this.enchantability > 0) {
            return this.enchantability;
        }
        return super.func_77619_b();
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (tab != CustomRegisters.tabItems && tab != CreativeTabs.field_78027_g) {
            return;
        }
        if (this.nbtData != null && this.nbtData.func_150297_b("ShowInCreative", 1) && !this.nbtData.func_74767_n("ShowInCreative")) {
            return;
        }
        items.add((Object)new ItemStack((Item)this));
        if (tab == CustomRegisters.tabItems) {
            Util.instance.sort(items);
        }
    }

    protected boolean func_185058_h_(@Nonnull ItemStack stack) {
        if (this.itemArrow != null && !this.itemArrow.func_190926_b()) {
            return stack.func_185136_b(this.itemArrow);
        }
        return stack.func_77973_b() instanceof ItemArrow;
    }

    public void func_77615_a(@Nonnull ItemStack stack, @Nonnull World worldIn, @Nonnull EntityLivingBase entityLiving, int timeLeft) {
        boolean flag1;
        float f;
        if (!(entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer entityplayer = (EntityPlayer)entityLiving;
        boolean flag = entityplayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
        ItemStack itemstack = this.func_185060_a(entityplayer);
        int i = this.func_77626_a(stack) - timeLeft;
        if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (EntityPlayer)entityplayer, (int)i, (!itemstack.func_190926_b() || flag ? 1 : 0) != 0)) < 0 || itemstack.func_190926_b() && !flag) {
            return;
        }
        if (itemstack.func_190926_b()) {
            itemstack = new ItemStack(Items.field_151032_g);
        }
        if ((double)(f = CustomBow.func_185059_b((int)i)) < 0.1) {
            return;
        }
        boolean bl = flag1 = entityplayer.field_71075_bZ.field_75098_d || itemstack.func_77973_b() instanceof ItemArrow && ((ItemArrow)itemstack.func_77973_b()).isInfinite(itemstack, stack, entityplayer);
        if (!worldIn.field_72995_K) {
            int k;
            ItemArrow itemarrow = (ItemArrow)(itemstack.func_77973_b() instanceof ItemArrow ? itemstack.func_77973_b() : Items.field_151032_g);
            EntityArrow entityarrow = itemarrow.func_185052_a(worldIn, itemstack, (EntityLivingBase)entityplayer);
            entityarrow.func_184547_a((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z, 0.0f, f * 3.0f, 1.0f);
            if (f == 1.0f) {
                entityarrow.func_70243_d(!(this.critChance > 0.0f) || !(this.critChance <= 1.0f) || Item.field_77697_d.nextFloat() < this.critChance);
            }
            int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
            double damage = (this.attackDamage > 0.0 ? this.attackDamage : entityarrow.func_70242_d()) * (i > 40 ? 1.0 : (double)i / 40.0);
            entityarrow.func_70239_b(damage);
            if (j > 0) {
                entityarrow.func_70239_b(damage + (double)j * 0.5 + 0.5);
            }
            if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                entityarrow.func_70240_a(k);
            }
            if (this.isFlame || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                entityarrow.func_70015_d(100);
            }
            stack.func_77972_a(1, (EntityLivingBase)entityplayer);
            if (flag1 || entityplayer.field_71075_bZ.field_75098_d && (itemstack.func_77973_b() == Items.field_185166_h || itemstack.func_77973_b() == Items.field_185167_i)) {
                entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
            }
            worldIn.func_72838_d((Entity)entityarrow);
        }
        worldIn.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
        if (!flag1 && !entityplayer.field_71075_bZ.field_75098_d) {
            itemstack.func_190918_g(1);
            if (itemstack.func_190926_b()) {
                entityplayer.field_71071_by.func_184437_d(itemstack);
            }
        }
        entityplayer.func_71029_a(Objects.requireNonNull(StatList.func_188057_b((Item)this)));
    }

    @Override
    public int getType() {
        if (this.nbtData != null && this.nbtData.func_150297_b("ItemType", 1)) {
            return this.nbtData.func_74771_c("ItemType");
        }
        return 5;
    }
}

